<?php
/*
Plugin Name: WPBeginner's Shortcake Tutorial Plugin
Plugin URI:  http://www.wpbeginner.com
Description: This plugin shows examples of using Shortcake API to add UI for shortcodes
Version:     1.0
Author:      WPBeginner
Author URI:  http://wpbeginner.com/
License: GPL v2 or later
 */
 
 
add_shortcode( 'mybutton', 'my_button_shortcode' );

function my_button_shortcode( $atts ) {
       extract( shortcode_atts(
               array(
                       'color' => 'blue',
                       'title' => 'Title',
                       'url' => ''
               ),
               $atts
       ));
       return '<span class="mybutton ' . $color . '-button"><a href="' . $url . '">' . $title . '</a></span>';
}

shortcode_ui_register_for_shortcode(

/** Your shortcode handle */
'mybutton',

/** Your Shortcode label and icon */
array(

/** Label for your shortcode user interface. This part is required. */
'label' => 'Add a colorful button',

/** Icon or an image attachment for shortcode. Optional. src or dashicons-$icon.  */
'listItemImage' => 'dashicons-flag',

/** Shortcode Attributes */
'attrs'          => array(

/**
* Each attribute that accepts user input will have its own array defined like this
* Our shortcode accepts two parameters or attributes, title and URL
* Lets first define the UI for title field. 
*/

array(

/** This label will appear in user interface */
'label'        => 'Title',

/** This is the actual attr used in the code used for shortcode */
'attr'         => 'title',

/** Define input type. Supported types are text, checkbox, textarea, radio, select, email, url, number, and date. */
'type'         => 'text',

/** Add a helpful description for users */
'description'  => 'Please enter the button text',
),

/** Now we will define UI for the URL field */

array(
'label'        => 'URL',
'attr'         => 'url',
'type'         => 'text',
'description'  => 'Full URL',
),

/** Finally we will define the UI for Color Selection */ 
array(
'label'		=> 'Color',
'attr'      => 'color',

/** We will use select field instead of text */
'type'		=> 'select',
    'options' => array(
        'blue'		=> 'Blue',
        'orange'	=> 'Orange',
        'green'		=> 'Green',
    ),
),

),

/** You can select which post types will show shortcode UI */
'post_type'     => array( 'post', 'page' ), 
)
);
 
function my_theme_add_editor_styles() {
    add_editor_style( plugins_url( 'css/tutorial-admin.css', __FILE__ ));
}
add_action( 'admin_init', 'my_theme_add_editor_styles' );
wp_enqueue_style( 'tutorial-styles', plugins_url( 'css/tutorial-front.css', __FILE__ ) );